/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.entity;

import com.queplix.entity.Table;
import com.queplix.entity.types.RefSType;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class DataschemaType
implements Serializable {
    private String _name;
    private RefSType _reftype = RefSType.valueOf("1:1");
    private ArrayList _tableList;

    public DataschemaType() {
        this.setReftype(RefSType.valueOf("1:1"));
        this._tableList = new ArrayList();
    }

    public void addTable(Table vTable) throws IndexOutOfBoundsException {
        if (this._tableList.size() >= 2) {
            throw new IndexOutOfBoundsException();
        }
        this._tableList.add(vTable);
    }

    public void addTable(int index, Table vTable) throws IndexOutOfBoundsException {
        if (this._tableList.size() >= 2) {
            throw new IndexOutOfBoundsException();
        }
        this._tableList.add(index, vTable);
    }

    public void clearTable() {
        this._tableList.clear();
    }

    public Enumeration enumerateTable() {
        return new IteratorEnumeration(this._tableList.iterator());
    }

    public String getName() {
        return this._name;
    }

    public RefSType getReftype() {
        return this._reftype;
    }

    public Table getTable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._tableList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Table)this._tableList.get(index);
    }

    public Table[] getTable() {
        int size = this._tableList.size();
        Table[] mArray = new Table[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Table)this._tableList.get(index);
        }
        return mArray;
    }

    public int getTableCount() {
        return this._tableList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeTable(Table vTable) {
        boolean removed = this._tableList.remove(vTable);
        return removed;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setReftype(RefSType reftype) {
        this._reftype = reftype;
    }

    public void setTable(int index, Table vTable) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._tableList.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= 2) {
            throw new IndexOutOfBoundsException();
        }
        this._tableList.set(index, vTable);
    }

    public void setTable(Table[] tableArray) {
        this._tableList.clear();
        for (int i = 0; i < tableArray.length; ++i) {
            this._tableList.add(tableArray[i]);
        }
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (DataschemaType)Unmarshaller.unmarshal(DataschemaType.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

