/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.ant.jssplitter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.regexp.RESyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.jresearch.jssplitter.jsprocessor.DescBean;
import org.jresearch.jssplitter.jsprocessor.JSFileProcessor;

public class JSConcatTask
extends Task {
    private String targetfile;
    private boolean compressed = true;
    protected ArrayList items;

    public void execute() throws BuildException {
        if (this.targetfile == null) {
            throw new BuildException("targetfile attribute is required");
        }
        String targetFile = null;
        try {
            targetFile = super.getProject().resolveFile(this.targetfile).getPath();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        DescBean desc = new DescBean();
        if (targetFile.endsWith(".cnct")) {
            try {
                desc = JSFileProcessor.readDesc(targetFile);
                int i = 0;
                while (i < desc.getItems().length) {
                    this.items.add(i, desc.getItems()[i]);
                    ++i;
                }
                desc.setItems(this.items.toArray());
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        } else if (targetFile.endsWith(".js")) {
            desc = new DescBean(this.items.toArray(), targetFile, this.compressed);
        } else {
            throw new BuildException("targetfile must be .cnct or .js");
        }
        this.log("Building " + desc.getTarget());
        try {
            JSFileProcessor.makeTarget(desc);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (RESyntaxException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void init() {
        super.init();
        this.items = new ArrayList();
    }

    public void addConfiguredFileset(FileSet fileset) {
        DirectoryScanner dirscan = fileset.getDirectoryScanner(super.getProject());
        String[] files = dirscan.getIncludedFiles();
        String path = dirscan.getBasedir().getPath() + File.separator;
        int i = 0;
        while (i < files.length) {
            this.items.add(path + files[i]);
            ++i;
        }
    }

    public void addConfiguredFilelist(FileList filelist) {
        String[] files = filelist.getFiles(super.getProject());
        String path = filelist.getDir(super.getProject()).getPath() + File.separator;
        int i = 0;
        while (i < files.length) {
            this.items.add(path + files[i]);
            ++i;
        }
    }

    public void log(String s) {
        super.log(s);
    }

    public void setTargetfile(String targetFile) {
        this.targetfile = targetFile;
    }

    public void setCompress(boolean compressed) {
        this.compressed = compressed;
    }
}

