/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.ant.jssplitter;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.jresearch.ant.jssplitter.JSConcatTask;

public class QXJSConcatTask
extends JSConcatTask {
    private Path path;
    private String implDir;
    private String implSuff;

    public void execute() throws BuildException {
        if (this.implDir == null) {
            throw new BuildException("impldir attribute is required");
        }
        if (this.implSuff == null) {
            throw new BuildException("implsuff attribute is required");
        }
        String[] list = this.path.list();
        int i = 0;
        while (i < list.length) {
            this.items.add(list[i]);
            ++i;
        }
        ArrayList<String> impls = new ArrayList<String>();
        Iterator it = this.items.iterator();
        try {
            while (it.hasNext()) {
                String path = (String)it.next();
                File file = new File(path);
                if (!file.exists() || !file.isFile()) {
                    throw new BuildException("cannot handle not a file");
                }
                String fileName = file.getName();
                String implName = path.substring(0, path.indexOf(fileName)) + this.implDir + File.separator + fileName.substring(0, fileName.lastIndexOf(".")) + this.implSuff;
                if (!new File(implName).exists()) continue;
                impls.add(implName);
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
        this.items.addAll(impls);
        super.execute();
    }

    public void setImpldir(String implDir) {
        this.implDir = implDir;
    }

    public void setImplsuff(String implSuff) {
        this.implSuff = implSuff;
    }

    public Path createPath() {
        this.path = new Path(this.getProject());
        return this.path;
    }
}

