/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.jssplitter.gui;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import org.jresearch.jssplitter.gui.Item;

public class IniBean
implements Serializable {
    private transient String currentDirectoryPath;
    private transient String startPath;
    private final transient String INIFNAME = "split.ini";
    private final transient int MAXSIZE = 7;
    private String lastDirectoryPath;
    private LinkedList recentList;

    public IniBean() {
        block3: {
            this.INIFNAME = "split.ini";
            this.MAXSIZE = 7;
            this.recentList = new LinkedList();
            this.startPath = new File(".").getAbsolutePath();
            this.startPath = this.startPath.substring(0, this.startPath.length() - 1);
            try {
                File f = new File("split.ini");
                if (!f.exists() || !f.canRead()) {
                    this.firstIni();
                    break block3;
                }
                ObjectInputStream oin = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.startPath + "split.ini")));
                IniBean old = (IniBean)oin.readObject();
                this.setRecentList(old.getRecentList());
                this.setLastDirectoryPath(old.getLastDirectoryPath());
                this.currentDirectoryPath = this.getLastDirectoryPath();
            }
            catch (Exception ex) {
                this.firstIni();
            }
        }
    }

    public String getLastDirectoryPath() {
        return this.lastDirectoryPath;
    }

    public void setLastDirectoryPath(String lastDirectoryPath) {
        this.lastDirectoryPath = lastDirectoryPath;
    }

    public LinkedList getRecentList() {
        return this.recentList;
    }

    public void setRecentList(LinkedList recentList) {
        this.recentList = recentList;
    }

    public void addRecent(Item nv) {
        if (this.recentList.contains(nv)) {
            this.recentList.remove(nv);
        }
        this.recentList.addFirst(nv);
        if (this.recentList.size() > 7) {
            this.recentList.removeLast();
        }
    }

    public void removeRecent(int n) {
        this.recentList.remove(n);
    }

    public void removeRecent(Item nv) {
        this.recentList.remove(nv);
    }

    public void firstIni() {
        this.currentDirectoryPath = this.startPath;
        this.setLastDirectoryPath(this.currentDirectoryPath);
    }

    public void saveIni() {
        try {
            this.setLastDirectoryPath(this.lastDirectoryPath);
            ObjectOutputStream oout = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.startPath + "split.ini")));
            oout.writeObject(this);
            oout.close();
        }
        catch (Exception ex) {
            System.err.println("saveIni " + ex.getMessage());
        }
    }
}

