/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.jssplitter.gui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.PlainDocument;
import org.apache.regexp.RESyntaxException;
import org.jresearch.jssplitter.gui.IniBean;
import org.jresearch.jssplitter.gui.Item;
import org.jresearch.jssplitter.gui.JSFileFilter;
import org.jresearch.jssplitter.jsprocessor.DescBean;
import org.jresearch.jssplitter.jsprocessor.JSFileProcessor;

public class MainPanel
extends JPanel {
    private IniBean ini;
    private String currentDirectoryPath = new String();
    private final String INIFNAME = "split.ini";
    private String startPath = new String();
    JTextField filename = new JTextField(25);
    PlainDocument pd = new PlainDocument();
    JButton tgb = new JButton("...");
    JButton addb = new JButton("Add file(s)");
    JButton remb = new JButton("Remove");
    JButton upb = new JButton("Move Up");
    JButton dwnb = new JButton("Move Down");
    JButton clearb = new JButton("Clear");
    JButton mkb = new JButton("Make");
    JCheckBox chbck = new JCheckBox("Compress source", true);
    DefaultListModel lItems = new DefaultListModel();
    JList select = new JList(this.lItems);
    JPanel mainbuttons = new JPanel();
    JPanel buttons = new JPanel();
    JScrollPane scroll = new JScrollPane(this.select, 22, 30);

    public MainPanel(IniBean ini) {
        this.ini = ini;
        FlowLayout theGrid = new FlowLayout();
        this.setLayout(theGrid);
        this.buttons.setLayout(new GridLayout(5, 1));
        this.mainbuttons.setLayout(new GridLayout(1, 2));
        this.select.setVisibleRowCount(10);
        this.addb.addActionListener(new AddL());
        this.remb.addActionListener(new RemL());
        this.tgb.addActionListener(new TgL());
        this.upb.addActionListener(new UpL());
        this.dwnb.addActionListener(new DownL());
        this.clearb.addActionListener(new ClearL());
        this.mkb.addActionListener(new MakeL());
        this.select.addListSelectionListener(new SelL());
        this.filename.setDocument(this.pd);
        this.pd.addDocumentListener(new FnameL());
        this.remb.setEnabled(false);
        this.upb.setEnabled(false);
        this.dwnb.setEnabled(false);
        this.mkb.setEnabled(false);
        this.clearb.setEnabled(false);
        this.add(this.scroll);
        this.buttons.add(this.addb);
        this.buttons.add(this.remb);
        this.buttons.add(this.upb);
        this.buttons.add(this.dwnb);
        this.buttons.add(this.clearb);
        this.add(this.buttons);
        this.add(this.chbck);
        this.add(new JLabel("                                                                                    "));
        this.add(new JLabel("Output file:"));
        this.add(this.filename);
        this.add(this.tgb);
        this.mainbuttons.add(this.mkb);
        this.add(this.mainbuttons);
        this.select.setBorder(new TitledBorder(new LineBorder(Color.white), "Source file(s):"));
    }

    void setEnableMake() {
        if (this.lItems.getSize() == 0) {
            this.clearb.setEnabled(false);
            this.mkb.setEnabled(false);
        } else {
            this.clearb.setEnabled(true);
            if (this.filename.getText().equals("")) {
                this.mkb.setEnabled(false);
            } else {
                this.mkb.setEnabled(true);
            }
        }
    }

    private void removeItem(Object[] items) {
        int i = 0;
        while (i < items.length) {
            this.lItems.removeElement(items[i]);
            ++i;
        }
        this.setEnableMake();
        this.remb.setEnabled(false);
    }

    public void target(String[] msk) {
        JFileChooser c = new JFileChooser(this.currentDirectoryPath);
        JSFileFilter jsf = new JSFileFilter(msk);
        c.setFileFilter(jsf);
        c.setAcceptAllFileFilterUsed(false);
        c.setMultiSelectionEnabled(false);
        int rVal = c.showOpenDialog(this);
        if (rVal == 0) {
            this.readTarget(c);
        }
    }

    private void readTarget(JFileChooser c) {
        block3: {
            block2: {
                this.currentDirectoryPath = c.getCurrentDirectory().toString();
                if (c.getDescription(c.getSelectedFile()).indexOf(".js") <= 0) break block2;
                this.filename.setText(c.getSelectedFile().getPath());
                break block3;
            }
            if (c.getDescription(c.getSelectedFile()).indexOf(".cnct") <= 0) break block3;
            try {
                this.readDesc(c.getSelectedFile().getPath(), false);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.mkb, "<html><b>Error:</b><br>" + ex.getMessage(), "Error", 0);
                System.err.println(ex.getMessage());
            }
        }
    }

    public void readDesc(String tgPath, boolean addItems) throws Exception {
        this.currentDirectoryPath = new File(tgPath).getParent();
        DescBean desc = JSFileProcessor.readDesc(tgPath);
        Object[] tmp = desc.getItems();
        if (!addItems) {
            this.lItems.clear();
        }
        int i = 0;
        while (i < tmp.length) {
            if (this.lItems.indexOf(tmp[i]) == -1) {
                this.lItems.add(this.lItems.getSize(), tmp[i]);
            }
            ++i;
        }
        this.filename.setText(desc.getTarget());
        this.chbck.setSelected(desc.isCompress());
    }

    class MakeL
    implements ActionListener {
        MakeL() {
        }

        public void actionPerformed(ActionEvent e) {
            block5: {
                File f = new File(MainPanel.this.filename.getText());
                int confirm = 0;
                if (f.exists()) {
                    if (f.canWrite()) {
                        confirm = JOptionPane.showConfirmDialog(MainPanel.this.mkb, "<html>File&nbsp;&nbsp;<b>" + f.getName() + "</b>&nbsp;&nbsp;alredy exist .<br> Are you really want to change this file ?", "", 0);
                    } else {
                        confirm = 1;
                        JOptionPane.showMessageDialog(MainPanel.this.mkb, "<html>The application is not allowed to write to the file&nbsp;&nbsp;<b>" + f.getName() + "</b> .", "", -1);
                    }
                }
                if (confirm != 0) break block5;
                try {
                    this.makeTarget(f);
                    JOptionPane.showMessageDialog(MainPanel.this.mkb, "<html>File&nbsp;&nbsp;<b>" + f.getName() + "</b>&nbsp;&nbsp;is generated successfully .", "", -1);
                    MainPanel.this.ini.saveIni();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MainPanel.this.mkb, ex.getMessage(), "Error", 0);
                    System.err.println(ex.getMessage());
                }
            }
        }

        private void makeTarget(File f) throws IOException, RESyntaxException {
            DescBean desc = new DescBean(MainPanel.this.lItems.toArray(), MainPanel.this.filename.getText(), MainPanel.this.chbck.isSelected());
            JSFileProcessor.makeTarget(desc);
            this.writeDesc(desc);
        }

        private void writeDesc(DescBean desc) throws RESyntaxException, IOException {
            File df = JSFileProcessor.writeDesc(desc);
            MainPanel.this.ini.addRecent(new Item(df.getName(), df.getPath()));
        }
    }

    class FnameL
    implements DocumentListener {
        FnameL() {
        }

        public void changedUpdate(DocumentEvent e) {
            MainPanel.this.setEnableMake();
        }

        public void insertUpdate(DocumentEvent e) {
            MainPanel.this.setEnableMake();
        }

        public void removeUpdate(DocumentEvent e) {
            MainPanel.this.setEnableMake();
        }
    }

    class SelL
    implements ListSelectionListener {
        SelL() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = MainPanel.this.select.getSelectedIndex();
            if (MainPanel.this.select.getSelectedValues().length == 1) {
                MainPanel.this.remb.setEnabled(true);
                if (index > 0) {
                    MainPanel.this.upb.setEnabled(true);
                } else {
                    MainPanel.this.upb.setEnabled(false);
                }
                if (index < MainPanel.this.lItems.getSize() - 1) {
                    MainPanel.this.dwnb.setEnabled(true);
                } else {
                    MainPanel.this.dwnb.setEnabled(false);
                }
            } else {
                if (MainPanel.this.select.getSelectedValues().length == 0) {
                    MainPanel.this.remb.setEnabled(false);
                } else {
                    MainPanel.this.remb.setEnabled(true);
                }
                MainPanel.this.upb.setEnabled(false);
                MainPanel.this.dwnb.setEnabled(false);
            }
        }
    }

    class DownL
    implements ActionListener {
        DownL() {
        }

        public void actionPerformed(ActionEvent e) {
            String tmp = "";
            int index = MainPanel.this.select.getSelectedIndex();
            tmp = (String)MainPanel.this.lItems.get(index);
            MainPanel.this.lItems.set(index, (String)MainPanel.this.lItems.get(index + 1));
            MainPanel.this.lItems.set(index + 1, tmp);
            MainPanel.this.select.clearSelection();
            MainPanel.this.select.setSelectedIndex(index + 1);
        }
    }

    class UpL
    implements ActionListener {
        UpL() {
        }

        public void actionPerformed(ActionEvent e) {
            String tmp = "";
            int index = MainPanel.this.select.getSelectedIndex();
            tmp = (String)MainPanel.this.lItems.get(index);
            MainPanel.this.lItems.set(index, (String)MainPanel.this.lItems.get(index - 1));
            MainPanel.this.lItems.set(index - 1, tmp);
            MainPanel.this.select.clearSelection();
            MainPanel.this.select.setSelectedIndex(index - 1);
        }
    }

    class TgL
    implements ActionListener {
        TgL() {
        }

        public void actionPerformed(ActionEvent e) {
            String[] msk = new String[]{"js", "cnct"};
            MainPanel.this.target(msk);
        }
    }

    class ClearL
    implements ActionListener {
        ClearL() {
        }

        public void actionPerformed(ActionEvent e) {
            MainPanel.this.removeItem(MainPanel.this.lItems.toArray());
        }
    }

    class RemL
    implements ActionListener {
        RemL() {
        }

        public void actionPerformed(ActionEvent e) {
            MainPanel.this.removeItem(MainPanel.this.select.getSelectedValues());
        }
    }

    class AddL
    implements ActionListener {
        AddL() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser c = new JFileChooser(MainPanel.this.currentDirectoryPath);
            String[] msk = new String[]{"js", "cnct"};
            c.setFileFilter(new JSFileFilter(msk));
            c.setAcceptAllFileFilterUsed(false);
            c.setMultiSelectionEnabled(true);
            int rVal = c.showOpenDialog(MainPanel.this);
            if (rVal == 0) {
                MainPanel.this.currentDirectoryPath = c.getCurrentDirectory().toString();
                File[] files = c.getSelectedFiles();
                int i = 0;
                while (i < files.length) {
                    if (!files[i].canRead()) {
                        JOptionPane.showMessageDialog(MainPanel.this.mkb, "<html>The application is not allowed to read from the file&nbsp;&nbsp;<b>" + files[i].getName() + "</b> .", "", -1);
                    } else if (MainPanel.this.lItems.indexOf(files[i].getPath()) == -1) {
                        if (files[i].getPath().endsWith(".js")) {
                            MainPanel.this.lItems.add(MainPanel.this.lItems.getSize(), files[i].getPath());
                        } else if (files[i].getPath().endsWith(".cnct")) {
                            try {
                                MainPanel.this.readDesc(c.getSelectedFile().getPath(), true);
                            }
                            catch (Exception ex) {
                                JOptionPane.showMessageDialog(MainPanel.this.mkb, "<html><b>Error:</b><br>" + ex.getMessage(), "Error", 0);
                                System.err.println(ex.getMessage());
                            }
                        }
                    }
                    ++i;
                }
                MainPanel.this.select.clearSelection();
            }
            MainPanel.this.setEnableMake();
        }
    }
}

