/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.jssplitter.jsprocessor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.jresearch.jssplitter.jsprocessor.DescBean;
import org.jresearch.jssplitter.jsprocessor.Sweeper;

public class JSFileProcessor {
    public static DescBean readDesc(String targetPath) throws IOException, ClassNotFoundException {
        ObjectInputStream oin = new ObjectInputStream(new BufferedInputStream(new FileInputStream(targetPath)));
        DescBean desc = (DescBean)oin.readObject();
        return desc;
    }

    public static File writeDesc(DescBean desc) throws RESyntaxException, IOException {
        RE rgxp = new RE(".js", 0);
        File df = new File(rgxp.subst(desc.getTarget(), ".cnct"));
        ObjectOutputStream oout = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(df)));
        oout.writeObject(desc);
        oout.close();
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeTarget(DescBean desc) throws IOException, RESyntaxException {
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String targetFile = desc.getTarget();
            File f = new File(targetFile);
            File rname = new File(targetFile + ".old");
            f.renameTo(rname);
            out = new PrintWriter(new BufferedWriter(new FileWriter(targetFile)));
            int i = 0;
            while (i < desc.getItems().length) {
                String item = (String)desc.getItems()[i];
                if (item.equals(targetFile)) {
                    item = item + ".old";
                }
                Sweeper sweeper = new Sweeper();
                in = new BufferedReader(new FileReader(item));
                String s = new String();
                while ((s = in.readLine()) != null) {
                    s = desc.isCompress() ? sweeper.sweep(s) : s + "\n";
                    if (s.equals("")) continue;
                    out.print(s);
                }
                in.close();
                ++i;
            }
            rname.delete();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public static void main(String[] args) {
        try {
            DescBean desc = JSFileProcessor.readDesc(args[0]);
            JSFileProcessor.makeTarget(desc);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

