set QUOTED_IDENTIFIER ON
go

create table dbo.TMP_QX_SYS_PROP (
  PROP_ID		VARCHAR(255),
  PROP_VAL		VARCHAR(255),
  PROP_TEXT		TEXT,
  PROP_DATA		IMAGE,
  NEED_RESTART		NUMERIC,
  DESCRIPTION		VARCHAR(255)
)

insert into dbo.TMP_QX_SYS_PROP select * from dbo.QX_SYS_PROP
go

drop table dbo.QX_SYS_PROP
go
create table dbo.QX_SYS_PROP (
  PKEY			INT	NOT NULL,
  PROP_ID		VARCHAR(255)	NOT NULL,
  PROP_VAL		VARCHAR(255),
  PROP_TEXT		TEXT,
  PROP_DATA		IMAGE,
  NEED_RESTART		NUMERIC		           DEFAULT 0,
  DESCRIPTION		VARCHAR(255),
constraint PK_QX_SYS_PROP primary key (PKEY)
)
go

DECLARE @propid varchar(255)
DECLARE @propval varchar(255)
DECLARE @needrestart NUMERIC
DECLARE @desc varchar(255)
DECLARE @stm varchar(1000)
DECLARE @id int

DECLARE cur CURSOR FOR
select
	PROP_ID, PROP_VAL, NEED_RESTART, DESCRIPTION
from
	dbo.TMP_QX_SYS_PROP
OPEN cur

FETCH NEXT FROM cur INTO @propid, @propval, @needrestart, @desc
WHILE (@@FETCH_STATUS = 0)
BEGIN
	EXEC dbo.QX_NEXT_KEY 'qx_sys_prop', 1, @id OUTPUT

	INSERT INTO QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) 
	values(@id, @propid, @propval, @desc, @needrestart)

	FETCH NEXT FROM cur INTO @propid, @propval, @needrestart, @desc
END
CLOSE cur
DEALLOCATE cur
go

drop table dbo.TMP_QX_SYS_PROP
go

-- all new update scripts must include a line like this:
UPDATE QX_SYS_PROP SET PROP_VAL = '009' WHERE (PROP_ID = 'DB_CORE_VERSION');
go
