/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Response object which contains all entity data for single entity.
 *
 * @author Sergey Kozmin
 * @since 30.10.2006, 11:02:25
 */
public class EntityDataResponseObject implements IsSerializable {
    private EntityData entityData;

    /**
     * Construct the response object with the given parameters
     *
     * @param entityData incoming entity data
     */
    public EntityDataResponseObject(EntityData entityData) {
        if(entityData != null) {
            this.entityData = entityData;
        } else {
            this.entityData = new EntityData();
        }
    }

    /**
     * Construct failed response, with apropriate message
     */
    public EntityDataResponseObject() {
        this(new EntityData());
    }

    public EntityData getEntityData() {
        return entityData;
    }

    public void setEntityData(EntityData entityData) {
        if(entityData != null) {
            this.entityData = entityData;
        }
    }
}
