/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

/**
 * That class contains all entity data and update status.
 *
 * @author Sergey Kozmin
 * @since 01.11.2006, 14:49:13
 */
public class EntityUpdateResponseObject extends AccumulatedEntityDataResponse {
    private RowData updatedRow;

    /**
     * Construct the response object with the given parameters
     *
     * @param dataForGrid        data for grid, already serialized to string
     * @param entitiesData       all the data, that was updated after the entity update
     * @param externalFieldsList updated external fields
     */
    public EntityUpdateResponseObject(EntityData[] entitiesData,
                                      EntityData[] externalFieldsList,
                                      RowData dataForGrid) {
        super(entitiesData, externalFieldsList, null);
        if(dataForGrid != null) {
            updatedRow = dataForGrid;
        } else {
            updatedRow = new RowData(new Long(-1), new String[0]);
        }
    }

    public EntityUpdateResponseObject() {
        this(null, null, null);
    }

    public RowData getUpdatedRow() {
        return updatedRow;
    }
}
