/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.queplix.core.client.app.vo.chart.ChartModel;
import com.queplix.core.client.app.vo.uisettings.FormUISettings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Represents Form metadata
 *
 * @author Sergey Kozmin
 * @since 13.10.2006, 13:18:37
 */
public class FormMeta implements IsSerializable {
    private FamgMeta.Index index;
    private String caption;
    private String icon;
    private EntityMeta entityMeta;
    private ContextMenuMeta contextMenu;
    private String pkeyID;
    private List externalForms;
    /**
     * Set of joinable forms. Set<FamgMeta.Index>
     */
    private Set joinableForms = new HashSet();
    private FormLayoutMeta layoutMeta;
    private FormButtonMeta[] buttons;
    private ChartModel[] charts;
    private FormHtmlElementMeta[] htmlElements;
    private FormLinkMeta[] links;
    //    private boolean defaultactions;
    private int labelsOrientation;
    private boolean inMyQueWeb = true;
    private boolean autoSearch;
    private String description;
    private FormUISettings uiSettings;
    private boolean visible;

    private final static FieldFilterMeta[] EMPTY_FILTERS_META = new FieldFilterMeta[0];
	private FieldFilterMeta[] filtersMeta = EMPTY_FILTERS_META;

	public static final class FieldFilterMeta implements IsSerializable {
		private String fieldId;
		private FamgMeta.Index byFormIdx;
		private String byFieldId;
		
		public FieldFilterMeta(){
		}

		public FieldFilterMeta(String fieldId,
				FamgMeta.Index byFormIdx, String byFieldId) {
			this.fieldId = fieldId;
			this.byFormIdx = byFormIdx;
			this.byFieldId = byFieldId;
		}
		
		public String getFieldId() {
			return fieldId;
		}
		
		public FamgMeta.Index getByFormIndex() {
			return byFormIdx;
		}

		public String getByFieldId() {
			return byFieldId;
		}

	}

    public FormMeta(EntityMeta entityMeta, String caption,
                    ContextMenuMeta contextMenu, String pkeyID) {
        externalForms = new ArrayList();
        if(entityMeta != null) {
            this.entityMeta = entityMeta;
        } else {
            this.entityMeta = new EntityMeta();
        }
        if(contextMenu != null) {
            this.contextMenu = contextMenu;
        } else {
            this.contextMenu = new ContextMenuMeta();
        }
        this.caption = caption;
        this.pkeyID = pkeyID;
        this.visible = true;
    }

    public FormMeta(EntityMeta entityMeta, String caption) {
        this(entityMeta, caption, null, "pkey");
    }

    public FormMeta() {
        this(null, "");
    }

    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEntityMeta(EntityMeta entityMeta) {
        if(entityMeta != null) {
            this.entityMeta = entityMeta;
        }
    }

    /**
     * couldn't be null object
     *
     * @return entity meta for that form
     */
    public EntityMeta getEntityMeta() {
        return entityMeta;
    }

    public void setContextMenu(ContextMenuMeta contextMenu) {
        this.contextMenu = contextMenu;
    }

    public FamgMeta.Index getIndex() {
        return index;
    }

    public void setIndex(FamgMeta.Index index) {
        this.index = index;
    }

    public ContextMenuMeta getContextMenu() {
        return contextMenu;
    }

    public String getPkeyID() {
        return pkeyID;
    }

    public void setPkeyID(String pkeyID) {
        this.pkeyID = pkeyID;
    }

    public List getExternalForms() {
        return externalForms;
    }

    public void addExternalForms(FamgMeta.Index externalForm) {
        externalForms.add(externalForm);
    }

    /**
     * Cannot be a null.
     *
     * @return joinable forms indexes object.
     */
    public Set getJoinableForms() {
        return joinableForms;
    }

    public void setJoinableForms(Set joinableForms) {
        if(joinableForms != null) {
            this.joinableForms = joinableForms;
        }
    }

    /**
     * Layout meta. Can be null; in this case some default layout will be used.
     *
     * @return layout meta
     */
    public FormLayoutMeta getLayoutMeta() {
        return layoutMeta;
    }

    public void setLayoutMeta(FormLayoutMeta layoutMeta) {
        this.layoutMeta = layoutMeta;
    }

    public FormButtonMeta[] getButtons() {
        if(buttons == null) {
            buttons = new FormButtonMeta[0];
        }
        return buttons;
    }

    public void setButtons(FormButtonMeta[] buttons) {
        this.buttons = buttons;
    }

    public ChartModel[] getCharts() {
        return charts;
    }

    public void setCharts(ChartModel[] charts) {
        this.charts = charts;
    }

    /*public boolean isDefaultactions() {
        return defaultactions;
    }
*/
    /*public void setDefaultactions(boolean defaultactions) {
        this.defaultactions = defaultactions;
    }*/

    public FormLinkMeta[] getLinks() {
        return links;
    }

    public void setLinks(FormLinkMeta[] links) {
        this.links = links;
    }

    public int getLabelsOrientation() {
        return labelsOrientation;
    }

    public void setLabelsOrientation(int labelsOrientation) {
        this.labelsOrientation = labelsOrientation;
    }

    public String getIcon() {
        return null;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isInMyQueWeb() {
        return inMyQueWeb;
    }

    public void setInMyQueWeb(boolean inMyQueWeb) {
        this.inMyQueWeb = inMyQueWeb;
    }

    public boolean isAutoSearch() {
        return autoSearch;
    }

    public void setAutoSearch(boolean autoSearch) {
        this.autoSearch = autoSearch;
    }

    public void setHtmlElements(FormHtmlElementMeta[] htmlElements) {
        this.htmlElements = htmlElements;
    }

    public FormHtmlElementMeta[] getHtmlElements() {
        if(htmlElements == null) {
            htmlElements = new FormHtmlElementMeta[0];
        }
        return htmlElements;
    }

    public FormUISettings getUISettings() {
        return uiSettings;
    }

    public void setUISettings(FormUISettings uiSettings) {
        this.uiSettings = uiSettings;
    }

    
	public FieldFilterMeta[] getFieldFiltersMeta(String fieldId) {
		if (fieldId == null)
			return EMPTY_FILTERS_META;

		List list = new ArrayList();
		for (int i = 0; i < filtersMeta.length; i++) {
			FieldFilterMeta filterMeta = filtersMeta[i];
			if (fieldId.equals(filterMeta.getFieldId()))
				list.add(filterMeta);
		}
		if(list.isEmpty())
			return EMPTY_FILTERS_META;

		FieldFilterMeta[] metas = new FieldFilterMeta[list.size()];
		for (int i = 0; i < list.size(); i++) {
			metas[i] = (FieldFilterMeta) list.get(i);
		}
		return metas;
	}

	public void setFieldFiltersMeta(FieldFilterMeta[] filtersMeta) {
		if (filtersMeta != null)
			this.filtersMeta = filtersMeta;
	}

    public boolean isVisible() {
        return visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

}