/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

/**
 * In form grid request for the type {@link #GET_CONTROL_DATA_TYPE}.
 *
 * @author Sergey Kozmin
 * @since 04.04.2007
 */
public class GetControlDataInformRequest extends InFormDataRequest {
    private FieldDataRequest request;

    public GetControlDataInformRequest(String elementID,
                                       FieldDataRequest request,
                                       String requestingEntity) {
        super(elementID, GET_CONTROL_DATA_TYPE, requestingEntity);
        this.request = request;
    }

    public GetControlDataInformRequest() {
        this("", null, "");
    }

    public FieldDataRequest getRequest() {
        return request;
    }

    public void setRequest(FieldDataRequest request) {
        this.request = request;
    }
}
