/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class contais response data for Load Report Request.
 *
 * @author Aliaksandr Melnik
 * @since 12 December 2006
 */
public class LoadReportResponseObject implements IsSerializable {
    private String reportName;
    /**
     * list of {@link com.queplix.core.client.app.vo.EntityData} elements
     */
    private List filters;
    /**
     * list of {@link com.queplix.core.client.app.vo.EntityElement}
     */
    private List reportFields;

    private String warningMessage;

    public LoadReportResponseObject(String reportName, String warningMessage,
                                    List filters, List reportFields) {
        this.warningMessage = warningMessage;
        this.reportName = reportName;
        setFilters(filters);
        setReportFields(reportFields);
    }

    public LoadReportResponseObject() {
        this("", null, null, null);
    }

    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public List getFilters() {
        return filters;
    }

    public void setFilters(List filters) {
        if(filters != null) {
            this.filters = filters;
        } else {
            this.filters = new ArrayList();
        }
    }

    public List getReportFields() {
        return reportFields;
    }

    public void setReportFields(List reportFields) {
        if(reportFields != null) {
            this.reportFields = reportFields;
        } else {
            this.reportFields = new ArrayList();
        }
    }

    public String getWarningMessage() {
        return warningMessage;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }
}
