/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;

import java.util.List;

/**
 * This class contais data wich is necessarily for Save Report Request.
 *
 * @author Aliaksandr Melnik
 * @author Sergey Kozmin
 * @since 8 Dec 2006
 */
public class SaveAdhocReportRequestObject extends AdhocFiltersRequest {
    private String reportName;
    private boolean reportPublic
            = false;//todo remove when will be known this is not user driven attribute

    public SaveAdhocReportRequestObject() {
    }

    public SaveAdhocReportRequestObject(List/*]<EntityData>[*/ filters,
                                        List/*]<ReportElement>[*/ fields,
                                        String reportName) {
        super(filters, fields);
        this.reportName = reportName;
    }

    public void init(List/*]<EntityData>[*/ filters,
                     List/*]<ReportElement>[*/ fields, String reportName) {
        init(filters, fields);
        this.reportName = reportName;
    }

    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }
}
