/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import java.util.List;

/**
 * In form grid on demand data for the type {@link #SEARCH_TYPE}.
 *
 * @author Sergey Kozmin
 * @since 04.04.2007
 */
public class SearchInformOnDemandData extends InFormGridOnDemandData {
    /**
     * List of {@link RowData}
     * List<RowData>
     */
    private List data;
    private int currentPage;
    private int totalRecordsCount;

    public SearchInformOnDemandData(String elementID, List data,
                                    int currentPage, int totalRecordsCount) {
        super(elementID, SEARCH_TYPE);
        this.data = data;
        this.currentPage = currentPage;
        this.totalRecordsCount = totalRecordsCount;
    }

    public SearchInformOnDemandData() {
        this("", null, -1, -1);
    }

    public List getData() {
        return data;
    }

    public void setData(List data) {
        this.data = data;
    }

    public int getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getTotalRecordsCount() {
        return totalRecordsCount;
    }

    public void setTotalRecordsCount(int totalRecordsCount) {
        this.totalRecordsCount = totalRecordsCount;
    }
}
