/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.queplix.core.client.common.StringUtil;

/**
 * @author alexander.epifanov
 */
public class SubsetItemMeta implements IsSerializable {
    private long id;
    private String caption;

    /**
     * Creates a new instance of SubsetItemMeta
     */
    public SubsetItemMeta(long id, String caption) {
        this.setId(id);
        this.setCaption(caption);
    }

    public SubsetItemMeta() {
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public boolean equals(SubsetItemMeta obj) {
        return obj.id == id && StringUtil.isStringsEqualsIgnoreNulls(
                obj.caption, caption);
    }
}
