/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo.chart;

import java.util.HashMap;
import java.util.Map;

/**
 * Represents detailed information about chart
 *
 * @author Michael Trofimov
 */
public class ChartDetails extends ChartMeta {

    private String title;
    private ChartOrientation orientation;
    private String colors;

    /**
     * GWT IsSerializable constructor
     */
    public ChartDetails() {
    }

    public ChartDetails(Long id) {
        super(id);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ChartOrientation getOrientation() {
        return orientation;
    }

    public void setOrientation(ChartOrientation orientation) {
        this.orientation = orientation;
    }

    public String getColors() {
        return colors;
    }

    public void setColors(String colors) {
        this.colors = colors;
    }

    /**
     * Use this method to produce {@link ChartMeta} from {@link ChartDetails}
     */
    public ChartMeta toMeta() {
        ChartMeta meta = new ChartMeta(getID());
        meta.setType(getType());
        meta.setWidth(getWidth());
        meta.setHeight(getHeight());
        meta.setFilters(getFilters());
        meta.setCategoryFieldFormId(getCategoryFieldFormId());
        meta.setDataFieldFormIds(getDataFieldFormIds());
        return meta;
    }
}
