/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo.chart;

import com.google.gwt.user.client.rpc.IsSerializable;

public class ChartOrientation implements IsSerializable {

    public static ChartOrientation VERTICAL = new ChartOrientation("vertical");
    public static ChartOrientation HORIZONTAL = new ChartOrientation(
            "horizontal");

    public static ChartOrientation[] ALL = new ChartOrientation[]{
            VERTICAL,
            HORIZONTAL
    };

    private String name;

    /**
     * GWT serialization constructor
     */
    public ChartOrientation() {
    }

    private ChartOrientation(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static ChartOrientation valueOf(String name) {
        for(int i = 0; i < ALL.length; i++) {
            ChartOrientation type = ALL[i];
            if(type.getName().equalsIgnoreCase(name)) {
                return type;
            }
        }
        return null;
    }

    public int hashCode() {
        return name.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || (o instanceof ChartOrientation
                && ((ChartOrientation) o).name.equals(name));
    }

    public String toString() {
//    	 GWT doesn't support getClass() method
//    	return "[" + getClass().getName() + "=" + name + "]";
        return "[ChartOrientation=" + name + "]";
    }
}
