/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common;

import com.google.gwt.user.client.rpc.IsSerializable;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * The HashMap that keeps the order of its items
 * Implemented due to the lack of LinkedHashMap support in GWT
 *
 * @author Vasily Mikhailitchenko
 * @since 19 Jan 2007
 */
public class OrderedHashMap implements IsSerializable {
    private ArrayList keys = new ArrayList();
    private HashMap map = new HashMap();

    public ArrayList getKeys() {
        return keys;
    }

    public Object put(Object key, Object value) {
        if(keys.contains(key)) {
            keys.remove(key);
        }
        keys.add(key);
        return map.put(key, value);
    }

    public Object remove(Object key) {
        keys.remove(key);
        return map.remove(key);
    }

    public Object get(Object key) {
        return map.get(key);
    }

    public ArrayList values() {
        ArrayList res = new ArrayList();
        for(int i = 0, n = keys.size(); i < n; i++) {
            Object key = keys.get(i);
            res.add(map.get(key));
        }
        return res;
    }

    public boolean containsKey(Object key) {
        return map.containsKey(key);
    }
}
