/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.error;

/**
 * Base class for all <strong>system-wide</strong> QueWeb exceptions.
 * <p/>
 * <p/>
 * This class emulates the <i>exception chaining</i> mechanism introduced in
 * JDK 1.4 to ensure the correct exception handling on JDK 1.3 level systems.
 * </p>
 *
 * @author [ALB] Baranov Andrey
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:06 $
 */
public class GenericSystemException
        extends RuntimeException {

    // ================================================================== Fields

    /**
     * The cause of this exception
     */
    private Throwable __cause = this;

    // ============================================================ Constructors

    /**
     * Constructs a new exception.
     */
    public GenericSystemException() {
        super();
    }

    /**
     * Creates a new exception with the specified detail message.
     *
     * @param message the detail message
     */
    public GenericSystemException(String message) {
        super(message);
    }

    /**
     * Creates a new exception with the specified cause.
     *
     * @param cause the cause
     */
    public GenericSystemException(Throwable cause) {
        this(null, cause);
    }

    /**
     * Creates a new exception with the specified detail message and cause.
     *
     * @param message the detail message
     * @param cause   the cause
     */
    public GenericSystemException(String message, Throwable cause) {
        super(message == null ? getCauseMessage(cause):message, cause);
        this.__cause = cause;
    }

    // ================================================================= Methods

    /**
     * Returns exception cause
     *
     * @return cause
     */
    public Throwable returnCause() {
        return __cause;
    }

    /**
     * Prints this throwable and its backtrace to the specified print writer.
     * @param s <code>PrintWriter</code> to use for output
     */
    /* public void printStackTrace( PrintWriter s ) {
        synchronized( s ) {
            super.printStackTrace( s );
            if( __cause != null && __cause != this ) {
                s.println( "Caused by:" + __cause );
                __cause.printStackTrace( s );
            }
        }
    }*/

    /**
     * Prints this throwable and its backtrace to the specified print stream.
     *
     * @param s <code>PrintStream</code> to use for output
     */
    /*public void printStackTrace( PrintStream s ) {
        synchronized( s ) {
            super.printStackTrace( s );
            if( __cause != null && __cause != this ) {
                s.println( "Caused by:" + __cause );
                __cause.printStackTrace( s );
            }
        }
    }
*/
    // Get cause message
    private static String getCauseMessage(Throwable cause) {
        return cause == null ? null:(cause.getMessage() == null ? cause
                .getClass().getName():cause.getMessage());

    }

}