/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.types.ControlSType;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>EQL request object</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLReq
        implements EQLReqSubOpMember, java.io.Serializable {

    // ------------------------------------------------------- variables

    // SELECT clause object
    private EQLReqSelect select;

    // FROM clause object
    private EQLReqFrom from;

    // WHERE clause object
    private EQLReqWhere where;

    // ORDER BY clause object
    private EQLReqOrder order;

    // EQL request meta data
    private EQLReqMetaData metaData;

    // List of EQLDReq objects
    private List eqlDReqList;

    // ------------------------------------------------------- constructors

    public EQLReq() {
        this.select = new EQLReqSelect();
        this.from = new EQLReqFrom();
        this.where = new EQLReqWhere();
        this.order = new EQLReqOrder();
    }

    // ------------------------------------------------------- public methods

    //
    // Getters/Setters
    //

    public EQLReqSelect getSelect() {
        return select;
    }

    public EQLReqFrom getFrom() {
        return from;
    }

    public EQLReqWhere getWhere() {
        return where;
    }

    public EQLReqOrder getOrder() {
        return order;
    }

    public void setMetaData(EQLReqMetaData metaData) {
        this.metaData = metaData;
    }

    public synchronized EQLReqMetaData getMetaData() {
        if(metaData == null) {
            metaData = new EQLReqMetaData();
        }
        return metaData;
    }

    // lazy fields

    public boolean isLazy(Efield field) {
        ControlSType type = field.getControl();
        if(type != null && (type.getType() == ControlSType.HISTORY_TYPE)) {
            return true;
        }
        if(metaData == null) {
            return false;
        }
        return metaData.isLazyLoadField(field);
    }

    // datasets EQLDReq

    public synchronized List getDReqs() {
        if(eqlDReqList == null) {
            eqlDReqList = new ArrayList();
        }
        return eqlDReqList;
    }

    public int getDReqSize() {
        return (eqlDReqList == null) ? 0:eqlDReqList.size();
    }

    public EQLDReq getDReq(int i) {
        if(getDReqSize() <= i) {
            return null;
        }

        return (EQLDReq) eqlDReqList.get(i);
    }

    public void addDReq(EQLDReq dReq) {
        getDReqs().add(dReq);
    }

    //
    // Others
    //

    // Copy object.

    public void copyOf(EQLReq req) {
        select = req.select;
        from = req.from;
        where = req.where;
        order = req.order;
        metaData = req.metaData;
        eqlDReqList = req.eqlDReqList;
    }

    // Hash.
    public int hashCode() {
        return select.hashCode() | from.hashCode() | where.hashCode() | order
                .hashCode();
    }

    // Equals.
    public boolean equals(Object o) {
        if(!(o instanceof EQLReq)) {
            return false;
        }

        if(o == this) {
            return true;
        }

        EQLReq req = (EQLReq) o;
        return select.equals(req.getSelect()) &&
                from.equals(req.getFrom()) &&
                where.equals(req.getWhere()) &&
                order.equals(req.getOrder());
    }
}
