/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

import com.queplix.core.modules.eql.error.EQLException;

/**
 * <p>EQL request function interface</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public interface EQLReqFunc
        extends java.io.Serializable {

    /**
     * Adds parameter.
     *
     * @param param EQLReqOp
     * @throws EQLException
     */
    void addParameter(EQLReqOp param)
            throws EQLException;

    /**
     * Returns number of parameters.
     *
     * @return int
     */
    int getSize();

    /**
     * Paremeter getter.
     *
     * @param i int
     * @return EQLReqOp
     */
    EQLReqOp getParameter(int i);
}
