/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

import java.util.List;

/**
 * <p>EQL Request Join Clause object</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLReqJoin
        implements java.io.Serializable {

    // ----------------------------------------------------- constants

    /**
     * use inner join - field is required
     */
    public static final int INNER_JOIN = 0;

    /**
     * use outer join - field can be NULL
     */
    public static final int OUTER_JOIN = 1;

    // ----------------------------------------------------- variables

    // left JOIN fields
    private List reqFields1;

    // right JOIN fields
    private List reqFields2;

    // type of join
    private int type;

    // special JOIN condition
    private EQLReqWhere reqWhere;

    // ----------------------------------------------------- constructor

    public EQLReqJoin(List reqFields1, List reqFields2, int type) {
        if(reqFields1 == null || reqFields2 == null) {
            throw new IllegalStateException();
        }
        if(reqFields1.size() != reqFields2.size()) {
            throw new IllegalStateException();
        }

        this.reqFields1 = reqFields1;
        this.reqFields2 = reqFields2;
        this.type = type;
    }

    // ----------------------------------------------------- public methods

    public int size() {
        return reqFields1.size();
    }

    public EQLReqField getLeftField(int i) {
        return (EQLReqField) reqFields1.get(i);
    }

    public EQLReqField getRightField(int i) {
        return (EQLReqField) reqFields2.get(i);
    }

    public EQLReqEntity getLeftEntity() {
        return ((EQLReqField) reqFields1.get(0)).getReqEntity();
    }

    public EQLReqEntity getRightEntity() {
        return ((EQLReqField) reqFields2.get(0)).getReqEntity();
    }

    public int getType() {
        return type;
    }

    public EQLReqWhere getReqWhere() {
        return reqWhere;
    }

    public void setReqWhere(EQLReqWhere reqWhere) {
        this.reqWhere = reqWhere;
    }

    public int hashCode() {
        return reqFields1.hashCode() | reqFields2.hashCode();
    }

    public boolean equals(Object o) {
        if(o == this) {
            return true;
        }

        if(!(o instanceof EQLReqJoin)) {
            return false;
        }

        // only reqFields1 and reqFields2 plays role for equals
        EQLReqJoin join = (EQLReqJoin) o;
        return reqFields1.equals(join.reqFields1) && reqFields2.equals(
                join.reqFields2);
    }
}
