/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

import java.util.ArrayList;

/**
 * <p>EQL Request Where Clause object</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:21 $
 */

public class EQLReqWhere implements java.io.Serializable {

    private ArrayList subWheres = new ArrayList();

    public void addSubWhere(EQLReqSubWhere subWhere) {
        subWheres.add(subWhere);
    }

    public ArrayList getSubWheres() {
        return subWheres;
    }

    public boolean contains(EQLReqSubWhere subWhere) {
        return subWheres.contains(subWhere);
    }

    public EQLReqSubWhere getSubWhere(int i) {
        return (EQLReqSubWhere) subWheres.get(i);
    }

    public int size() {
        return subWheres.size();
    }

    public int hashCode() {
        return subWheres.hashCode();
    }

    public boolean equals(Object o) {
        if(o == this) {
            return true;
        }

        if(!(o instanceof EQLReqWhere)) {
            return false;
        }

        return subWheres.equals(((EQLReqWhere) o).subWheres);
    }

}