/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql.lock;

/**
 * Lock ID compound key
 *
 * @author [SVM] Maxim Suponya
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:26 $
 */

public class LockID implements java.io.Serializable {

    public String table_name;
    public String record_id;
    public String record_id2;
    public String record_id3;
    public String record_id4;

    public LockID() {
    }

    public LockID(String tableName, String[] recordIds) {
        this(tableName, recordIds[0], recordIds[1], recordIds[2], recordIds[3]);
    }

    public LockID(String tableName,
                  String recordId,
                  String recordId2,
                  String recordId3,
                  String recordId4) {
        this.table_name = tableName;
        this.record_id = recordId;
        this.record_id2 = recordId2;
        this.record_id3 = recordId3;
        this.record_id4 = recordId4;
    }

    public int hashCode() {
        return table_name.hashCode() | record_id.hashCode() |
                (record_id2 == null ? 1:record_id2.hashCode()) |
                (record_id3 == null ? 1:record_id3.hashCode()) |
                (record_id4 == null ? 1:record_id4.hashCode());
    }

    public boolean equals(Object obj) {
        if(obj == this) {
            return true;
        }

        if(obj instanceof LockID) {
            LockID temp = (LockID) obj;
            return temp.table_name.equals(table_name) &&
                    temp.record_id.equals(record_id) &&
                    ((temp.record_id2 == null && record_id2 == null) ||
                            (temp.record_id2 != null && record_id2 != null
                                    && temp.record_id2.equals(record_id2))) &&
                    ((temp.record_id3 == null && record_id3 == null) ||
                            (temp.record_id3 != null && record_id3 != null
                                    && temp.record_id3.equals(record_id3))) &&
                    ((temp.record_id4 == null && record_id4 == null) ||
                            (temp.record_id4 != null && record_id4 != null
                                    && temp.record_id4.equals(record_id4)));
        }

        return false;
    }

    public String getTable_name() {
        return table_name;
    }

    public String getRecord_id() {
        return record_id;
    }

    public String getRecord_id2() {
        return record_id2;
    }

    public String getRecord_id3() {
        return record_id3;
    }

    public String getRecord_id4() {
        return record_id4;
    }
}
