/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql.parser.generic;

import com.queplix.core.modules.eql.EQLReqEntity;
import com.queplix.core.modules.eql.EQLReqField;
import com.queplix.core.modules.eql.EQLReqSubWhereCond;
import com.queplix.core.modules.eql.error.EQLException;

import java.util.List;

/**
 * <p>EQL request builder interface</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:30 $
 */

public interface InterfaceEQLRequestBuilder {

    /**
     * Add Entity (using ChainTable for reference)
     *
     * @param reqEntity EQLReqEntity object
     * @throws EQLException
     */
    void addEntity(EQLReqEntity reqEntity)
            throws EQLException;

    /**
     * Add Efield object using <code>Ref</code>
     *
     * @param reqField EQLReqField object
     * @return EQLReqField object
     * @throws EQLException
     */
    EQLReqField addField(EQLReqField reqField)
            throws EQLException;

    /**
     * Add Efield object using <code>Ref</code>
     *
     * @param reqField EQLReqField object
     * @param withRef  add all refences from Ref or not
     * @return EQLReqField object
     * @throws EQLException
     */
    EQLReqField addField(EQLReqField reqField, boolean withRef)
            throws EQLException;

    /**
     * Add list reference
     *
     * @param reqField EQLReqField object
     * @return EQLReqField object
     * @throws EQLException
     */
    EQLReqField addListField(EQLReqField reqField)
            throws EQLException;

    /**
     * Add EQLReq join ( <field1> = <field2> )
     *
     * @param reqFields1   left Req field
     * @param reqFields2   right Req field
     * @param leftReqField indicates field we need to add join (optional)
     * @return true if added
     * @throws EQLException
     */
    boolean addJoin(List reqFields1, List reqFields2, EQLReqField leftReqField)
            throws EQLException;

    /**
     * Add EQLReq where
     *
     * @param reqField left Req field
     * @param cond     operation
     * @return true if added
     * @throws EQLException
     */
    boolean addWhere(EQLReqField reqField, EQLReqSubWhereCond cond)
            throws EQLException;
}
