/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.actions;

import com.queplix.core.modules.eql.EQLRes;
import com.queplix.core.modules.eql.conds.LikeCond;
import com.queplix.core.modules.eql.parser.generic.SQLExecutorGenericImpl;
import com.queplix.core.modules.eql.parser.generic.SQLSelectBuilderGenericImpl;
import com.queplix.core.modules.eqlext.jxb.gr.ResHeader;
import com.queplix.core.modules.eqlext.jxb.gr.ResRecord;
import com.queplix.core.utils.StringHelper;

import java.io.Writer;

/**
 * <p>Main GetRecords action interface</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:37 $
 */

public interface GRAction
        extends Action {

    // Standard EQL meta-inf parameters and values
    String DISTINCT_PARAM = SQLSelectBuilderGenericImpl.DISTINCT_PARAM;
    String PAGE_PARAM = SQLExecutorGenericImpl.PAGE_PARAM;
    String PAGE_SIZE_PARAM = SQLExecutorGenericImpl.PAGE_SIZE_PARAM;
    String HAS_MORE_PARAM = SQLExecutorGenericImpl.HAS_MORE_PARAM;

    int UNDEFINED_COUNT = StringHelper.EMPTY_NUMBER;
    int UNDEFINED_PAGE = StringHelper.EMPTY_NUMBER;
    int UNDEFINED_PAGESIZE = StringHelper.EMPTY_NUMBER;

    // Standard EQL Ext parameters and values
    String USE_BUILTIN_COUNT_PARAM = "useBuiltinCount";

    // Special pattern characters in EQL queries
    char EQL_ESCAPE_CHARACTER = LikeCond.ESCAPE_CHARACTER;
    char EQL_ASTERISC_OP = LikeCond.ASTERISC_OP;
    char EQL_QUESTION_OP = LikeCond.QUESTION_OP;

    // Escape character in user queries
    char ESCAPE_CHARACTER = '\\';
    // Special EQL prepared statement character
    char PS_CHARACTER = '?';
    // Logical AND character in user queries
    char AND_CHARACTER = '&';
    // Logical OR character in user queries
    char OR_CHARACTER = '|';

    // String pattern characters in user queries
    char ASTERISC_OP = '*';
    char QUESTION_OP = '?';
    char TICK_OP = '^';
    char DOLLAR_OP = '$';
    char DOG_OP = '@';

    // Date pattern characters in user queries
    String BETWEEN_OP = "..";

    // All user query operations
    String QUERY_EQ_OP = "=";
    String QUERY_NE_OP = "!";
    String QUERY_GT_OP = ">";
    String QUERY_LT_OP = "<";
    String QUERY_GTEQ_OP = ">=";
    String QUERY_LTEQ_OP = "<=";

    // All user query operation ids
    int NONE_OP = 0;
    int EQ_OP = 1;
    int NE_OP = 2;
    int GT_OP = 3;
    int LT_OP = 4;
    int GTEQ_OP = 5;
    int LTEQ_OP = 6;

    // External and internal dataset attrs
    int EXTERNAL_ATTR = 0;
    int INTERNALL_ATTR = 1;

    // Properties.
    String FORM_ID_PARAM = "formId";
    String IGNORE_SEND_ON_REQ_PARAM = "ignoreSendOnRequest";

    /**
     * Set writer for records writing.
     *
     * @param writer Writer object
     */
    void setWriter(Writer writer);

    /**
     * Get count records in database
     *
     * @return rows in database
     */
    int getCount();

    /**
     * Get count rows retrived from database
     *
     * @return rows in package
     */
    int getRows();

    /**
     * Has more records in database
     *
     * @return true or false
     */
    boolean hasMore();

    /**
     * Get response header
     *
     * @return ResHeader object
     */
    ResHeader getHeader();

    /**
     * Get EQL response
     *
     * @return EQLRes object
     */
    EQLRes getEQLRes();

    /**
     * Get array of retrived ResRecord objects
     *
     * @return array
     */
    ResRecord[] getResRecords();

    /**
     * Get writer for records writing.
     *
     * @return Writer object
     */
    Writer getWriter();
}
