/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.transforms.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.eqlext.transforms.EfieldTransform;
import com.queplix.core.modules.eqlext.utils.images.MemoTransformManager;
import com.queplix.core.modules.eqlext.utils.images.ReStruct;
import com.queplix.core.utils.StringHelper;

/**
 * <p>Default memo transform class</p>
 *
 * @author [ALB] Baranov L. Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:40 $
 */

public class MemoTransform
        extends EfieldTransform {

    // ----------------------------------------------------- constants

    // Client regular expression to find attachment in the memo.
    // We recive this memo from thin client (web browser).
    private static final String CLIENT_REG_EXP =
            "<A\\s+href=\"javascript:parent\\.viewImageHandler\\('([^']+)/([^']+)'\\);\">(.*?)</A>";

    // Client link on attachment representation.
    private static final String CLIENT_FORMAT =
            "<A href=\"javascript:parent.viewImageHandler('{2}/{1}');\">{3}</A>";

    // Client regexp structure.
    private static final ReStruct reClientStruct = new ReStruct(CLIENT_REG_EXP,
            2, 1, 3);

    // ----------------------------------------------------- public methods

    //
    // Convert String to Object
    //

    public Object toObject(LogonSession ls, Entity entity, Efield field,
                           String s) {
        if(!StringHelper.isEmpty(s)) {
            s = convertToSystem(s);
        }
        return s.toCharArray();
    }

    //
    // Convert Object to String
    //
    public String toString(LogonSession ls, Entity entity, Efield field,
                           Object o) {
        char[] data = (char[]) o;
        String s = StringHelper.clear(String.valueOf(data));
        if(StringHelper.isEmpty(s)) {
            return s;
        } else {
            return convertToClient(s);
        }
    }

    // ----------------------------------------------------- private methods

    //
    // Cut all client attachment tags from the memo text.
    // Insert system tags instead.
    //

    public static String convertToSystem(String s) {
        MemoTransformManager mtm = new MemoTransformManager(s);
        return mtm.convertToSystem(reClientStruct);
    }

    //
    // Cut all system attachment tags from the memo text.
    // Insert client tags instead.
    //
    public static String convertToClient(String s) {
        MemoTransformManager mtm = new MemoTransformManager(s);
        return mtm.convertToClient(CLIENT_FORMAT);
    }

    //
    // Only for testing
    //
    public static void main(String[] args)
            throws Exception {

        String s =
                "<html>" +
                        "<P>nanaan <STRONG>hello!!!</STRONG> </P>\n" +
                        "<P>&nbsp;</P>\n" +
                        "<P><A href=\"javascript:parent.viewImageHandler('te/AUT_0056.JPG');\"><STRIKE>te/AUT_0056.JPG</STRIKE></A></P>\n"
                        +
                        "<P><A href=\"javascript:parent.viewImageHandler('48/ad/kot2.jpg');\">48/ad/kot2.jpg</A></P>\n"
                        +
                        "<P>&nbsp;</P>\n" +
                        "<P><A href=\"javascript:parent.viewImageHandler('re/EQL.txt');\">re/EQL.txt</A><A href=\"javascript:parent.viewImageHandler('48/ad/kot2.jpg');\"></A></P>"
                        +
                        "</html>";

        System.out.println("Client string:");
        System.out.println(s);
        System.out.println("\n\n");

        s = convertToSystem(s);

        System.out.println("System string:");
        System.out.println(s);
        System.out.println("\n\n");

        s = convertToClient(s);

        System.out.println("Client string again:");
        System.out.println(s);
        System.out.println("\n\n");
    }
}
