/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.update.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.modules.jeo.gen.ReportObject;
import com.queplix.core.modules.jeo.gen.ReportObjectHandler;
import com.queplix.core.utils.JNDINames;

/**
 * Report update.
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.2 $ $Date: 2006/09/19 11:12:32 $
 */

public class ReportUpdate
        extends EntityUpdate {

    // ========================================================== Update handler

    /* (non-Javadoc)
     * @see EntityUpdate#beforeUpdate()
     */

    public int beforeUpdate()
            throws EQLException {

        long time = System.currentTimeMillis();
        INFO("Report before update started...");

        // Initialization.
        LogonSession ls = getEUO().getSession().getLogonSession();
        long userID = ls.getUser().getUserID();

        // Get the current report request record.
        JEObjectHandler hnd = getJEOHandler(ReportObjectHandler.class);
        ReportObject obj = (ReportObject) hnd.getJEObject();

        // Check request
        Long ownerID = obj.getOwner_id();
        Integer i = obj.getPublic_report();
        boolean publicReport = (i != null && i != 0);

        // Throw an exception, if it is a non-public foreign report.
        if(!publicReport) {
            if(ownerID != null && ownerID != userID) {
                throw new EQLException(
                        "You can't update report not owned by you.");
            }
        }

        // Ok.
        INFO("Report before update completed, time = "
                + (System.currentTimeMillis() - time) + " ms.");
        return CONTINUE;
    }

    /**
     * Before-delete handler.
     *
     * @return update status
     * @throws com.queplix.core.modules.eql.error.EQLException
     *
     */
    public int beforeDelete()
            throws EQLException {

        long time = System.currentTimeMillis();
        INFO("Report before delete started...");

        // Initialization.
        JEOManagerLocal jeoManager = (JEOManagerLocal) getCOM().
                getLocalObject(JNDINames.JEOManager, JEOManagerLocalHome.class);

        LogonSession ls = getEUO().getSession().getLogonSession();
        long userID = ls.getUser().getUserID();

        Integer reportId = getCell("report_id").getInteger();
        ReportObjectHandler rHnd = (ReportObjectHandler) ReportObjectHandler
                .selectByID(jeoManager, ls, reportId);

        if(rHnd != null) {
            ReportObject rObj = (ReportObject) rHnd.getJEObject();

            Long ownerId = rObj.getOwner_id();

            // Check delete request, if non-admin.
            // Throw an exception, if user is not a report owner
            if(ownerId != null && ownerId != userID) {
                throw new EQLException(
                        "You can't delete report not owned by you.");
            }
        }
        // Ok.
        INFO("Report before delete completed, time = "
                + (System.currentTimeMillis() - time) + " ms.");

        return CONTINUE;
    }
}
