/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.inbox.ejb;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.inbox.InboxMessage;

import javax.mail.MessagingException;
import java.util.Properties;

/**
 * The Inbox manager remote interface.
 *
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public interface InboxManager extends javax.ejb.EJBObject {

    long getUniqueMessageID() throws java.rmi.RemoteException;

    boolean saveMailToInbox(LogonSession ls, InboxMessage message)
            throws java.rmi.RemoteException;

    void saveMailToOutbox(LogonSession ls, InboxMessage message)
            throws java.rmi.RemoteException;
    void deleteTempAttachment(LogonSession ls, InboxMessage inboxMessage) throws java.rmi.RemoteException;

    void saveMailToTrash(LogonSession ls, InboxMessage message)
            throws java.rmi.RemoteException;

    boolean sendEmailMessage(LogonSession ls, InboxMessage message,
                             Properties mailHeaders)
            throws MessagingException, java.rmi.RemoteException;

    boolean sendAlertMessage(LogonSession ls, InboxMessage inboxMessage)
            throws java.rmi.RemoteException;

    boolean linkAttachmentsToObject(LogonSession ls, InboxMessage inboxMessage)
            throws java.rmi.RemoteException;

} // interface InboxManager
