/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.inbox.utils;

import com.queplix.core.modules.inbox.Account;
import com.queplix.core.modules.inbox.InboxHelper;
import com.queplix.core.utils.dao.AbstractVO;
import com.queplix.core.utils.dao.InterfaceDAO;

import java.util.Date;

/**
 * This is abstract class for Mail Accounts.
 *
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public class AccountVO extends AbstractVO implements Account {

    // ================================================================= Fields

    // Primary data.
    private long accountID;
    private String providerName;
    private String server;
    private Integer port;
    private String folderName;
    private String name;
    private String password;
    private Integer delayInMinutes;
    private Long maxMessageSize;
    private Long maxMailboxSize;
    private Boolean deleteMailFlag;
    private Boolean markEmailAsSeenFlag;
    private Long defaultOwner;
    private Long defaultWorkgroup;

    // Additional data.
    private Boolean validFlag;
    private Date lastReceiveDate;
    private String messageUID;
    private String messageDigest;
    //private Long currentMailboxSize;
    //private Date nextCheckDate;

    // ================================================================= Constructors

    //
    // Constructor.
    //

    public AccountVO(long _accountID,
                     String _providerName,
                     String _server,
                     Integer _port,
                     String _folderName,
                     String _name,
                     String _password,
                     Integer _delayInMinutes,
                     Long _maxMessageSize,
                     Long _maxMailboxSize,
                     Boolean _deleteMailFlag,
                     Boolean _markEmailAsSeenFlag,
                     Long _defaultOwner,
                     Long _defaultWorkgroup,
                     String _messageUID,
                     String _messageDigest
    ) {

        accountID = _accountID;
        providerName = _providerName;
        server = _server;
        port = _port;
        folderName = _folderName;
        name = _name;
        password = _password;
        delayInMinutes = _delayInMinutes;
        maxMessageSize = _maxMessageSize;
        maxMailboxSize = _maxMailboxSize;
        deleteMailFlag = _deleteMailFlag;
        markEmailAsSeenFlag = _markEmailAsSeenFlag;
        defaultOwner = _defaultOwner;
        defaultWorkgroup = _defaultWorkgroup;
        messageUID = _messageUID;
        messageDigest = _messageDigest;
    }

    // ================================================================= Overrided Methods

    /*
     * No javadoc
     * @see Account#getAccountID
     */

    public long getAccountID() {
        return accountID;
    }

    /*
     * No javadoc
     * @see Account#getProviderName
     */
    public String getProviderName() {
        return providerName;
    }

    /*
     * No javadoc
     * @see Account#getServer
     */
    public String getServer() {
        return server;
    }

    /*
     * No javadoc
     * @see Account#getPort
     */
    public Integer getPort() {
        return port;
    }

    /*
     * No javadoc
     * @see Account#getFolderName
     */
    public String getFolderName() {
        return folderName;
    }

    /*
     * No javadoc
     * @see Account#getName
     */
    public String getName() {
        return name;
    }

    /*
     * No javadoc
     * @see Account#getPassword
     */
    public String getPassword() {
        return password;
    }

    /*
     * No javadoc
     * @see Account#getDelayInMinutes
     */
    public Integer getDelayInMinutes() {
        return delayInMinutes;
    }

    /*
     * No javadoc
     * @see Account#getMaxMessageSize
     */
    public Long getMaxMessageSize() {
        return maxMessageSize;
    }

    /*
     * No javadoc
     * @see Account#getMaxMailboxSize
     */
    public Long getMaxMailboxSize() {
        return maxMailboxSize;
    }

    /*
     * No javadoc
     * @see Account#getMessageUID
     */
    public String getMessageUID() {
        return messageUID;
    }

    /*
     * No javadoc
     * @see Account#getMessageDigest
     */
    public String getMessageDigest() {
        return messageDigest;
    }

    /*
     * No javadoc
     * @see Account#getValidFlag
     */
    public Boolean getValidFlag() {
        validFlag = ((AccountDAO) getController()).loadValidFlag(this);

        DEBUG("loaded valid state: " + validFlag);

        return validFlag;
    }

    /*
     * No javadoc
     * @see Account#getDeleteMailFlag
     */
    public Boolean getDeleteMailFlag() {
        return deleteMailFlag;
    }

    /*
     * No javadoc
     * @see Account#getMarkEmailAsSeenFlag
     */
    public Boolean getMarkEmailAsSeenFlag() {
        return markEmailAsSeenFlag;
    }

    /*
     * No javadoc
     * @see Account#getLastReceiveDate
     */
    public Date getLastReceiveDate() {
        lastReceiveDate = ((AccountDAO) getController()).loadLastReceiveDate(
                this);

        DEBUG("loaded last receive date: " + lastReceiveDate);

        return lastReceiveDate;
    }

    /*
     * No javadoc
     * @see Account#setValidFlag
     */
    public void setValidFlag(Boolean b) {
        ((AccountDAO) getController()).storeValidFlag(this, b);
        validFlag = b;
    }

    /*
     * No javadoc
     * @see Account#setLastReceiveDate
     */
    public void setLastReceiveDate(Date d, String messageUID,
                                   String messageDigest) {
        ((AccountDAO) getController()).storeLastReceiveDate(this, d, messageUID,
                messageDigest);
        lastReceiveDate = d;
        this.messageUID = messageUID;
        this.messageDigest = messageDigest;
    }

    /*
     * No javadoc
     * @see Account#setLastReceiveDate
     */
    public void setLastMessageID(String messageUID, String messageDigest) {
        ((AccountDAO) getController()).storeLastMessageID(this, messageUID,
                messageDigest);
        this.messageUID = messageUID;
        this.messageDigest = messageDigest;
    }

    /*
     * No javadoc
     * @see Account#setNextCheckDate
     */
    public void setNextCheckDate(Date d) {
        ((AccountDAO) getController()).storeNextCheckDate(this, d);
        //nextCheckDate = d;
    }

    /*
     * No javadoc
     * @see AbstractVO#getControler
     */
    protected InterfaceDAO getController() {
        return InboxPropertyFactory.getInstance().getAccountDAO();
    }

    /*
     * No javadoc
     * @see Object#equals
     */
    public boolean equals(Object obj) {
        if(obj == null || !(obj instanceof AccountVO)) {
            return false;
        }
        AccountVO vo = (AccountVO) obj;
        return vo.getAccountID() == getAccountID();
    }

    /*
     * No javadoc
     * @see Object#hashCode
     */
    public int hashCode() {
        return (int) getAccountID();
    }

    /*
     * No javadoc
     * @see Account#getDefaultOwner
     */
    public Long getDefaultOwner() {
        return defaultOwner;
    }

    /*
     * No javadoc
     * @see Account#getDefaultWorkgroup
     */
    public Long getDefaultWorkgroup() {
        return defaultWorkgroup;
    }

    /*
     * No javadoc
     * @see Object#toString
     */
    public String toString() {
        return "id=" + accountID +
                "; uri=" + InboxHelper.toURI(this) +
                "; delay (min)=" + delayInMinutes +
                "; max message size=" + maxMessageSize +
                "; delete?=" + deleteMailFlag +
                "; mark as seen?=" + markEmailAsSeenFlag +
                "; last receive=" + lastReceiveDate;
        //"; current size=" + currentMailboxSize;
    }
}
