/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.jeo.JEObject;

/**
 * Autoreply object.
 *
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public interface AutoreplyObject extends JEObject {

    public Long getPkey();

    public String getName();

    public String getDescription();

    public String getReply_email();

    public String getSuccessful_subject();

    public char[] getSuccessful_body();

    public String getUpdate_subject();

    public char[] getUpdate_body();

    public String getFail_subject();

    public char[] getFail_body();

} // interface AutoreplyObject
