/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * <p>History handler</p>
 *
 * @author [LIV] Ladnev Ilya
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:47 $
 */
public class HistoryObjectHandler
        extends JEObjectHandler {

    public String getEntityName() {
        return "history";
    }

    public Class getObjectClass() {
        return HistoryObject.class;
    }

    /**
     * Select by ID
     *
     * @param local     JEOManager local interface
     * @param ls        user logon session
     * @param historyId history ID
     * @return JEObjectHandler object
     * @throws EQLException
     */
    public static JEObjectHandler selectById(JEOManagerLocal local,
                                             LogonSession ls,
                                             long historyId)
            throws EQLException {

        String eql = "SELECT history.* WHERE history.qx_historyid = "
                + historyId;

        List hndList = local.select(ls, HistoryObjectHandler.class, eql);
        if(hndList == null) {
            return null;
        } else {
            return (JEObjectHandler) hndList.get(0);
        }
    }

    /**
     * Select by Object
     *
     * @param local     JEOManager local interface
     * @param ls        user logon session
     * @param historyId history ID
     * @return JEObjectHandler object
     * @throws EQLException
     */
    public static JEObjectHandler selectByObj(JEOManagerLocal local,
                                              LogonSession ls,
                                              String objName,
                                              long objId)
            throws EQLException {

        String eql = "SELECT history.* WHERE history.qx_object = '" + objName
                + "' AND history.qx_objectid = " + objId;

        List hndList = local.select(ls, HistoryObjectHandler.class, eql);
        if(hndList == null) {
            return null;
        } else {
            return (JEObjectHandler) hndList.get(0);
        }
    }
}
