/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.services.utils;

import com.queplix.core.modules.services.jxb.Script;
import com.queplix.core.utils.dao.InterfaceDAO;

import java.util.Collection;

/**
 * Script DAO interface
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:01 $
 */

public interface ScriptDAO
        extends InterfaceDAO {

    /**
     * Deletes Script record
     *
     * @param script Script object
     * @return number of deleted records
     */
    int deleteScriptVO(Script script);

    /**
     * Updates current Script record
     *
     * @param script Script object
     * @return number of updated records
     */
    int updateScriptVO(Script script);

    /**
     * Load script VO by its ID
     *
     * @param scriptId script ID
     * @return Script object
     */
    Script loadScriptVO(int scriptId);

    /**
     * Load script VO by its name
     *
     * @param scriptName script name
     * @return Script object
     */
    Script loadScriptVO(String scriptName);

    /**
     * Load All script VO
     *
     * @return Collection of Script objects
     */
    Collection loadAllScriptVO();
}
