/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.services.utils.log;

import com.queplix.core.modules.config.utils.SysPropertyManager;
import com.queplix.core.utils.log.AbstractLogger;
import com.queplix.core.utils.sql.SqlWrapper;
import com.queplix.core.utils.sql.SqlWrapperFactory;

/**
 * Abstract LOG handler.
 * The class wich overrides this abstract class should be thread safe.
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:01 $
 * @see #AsyncMDB
 */

public abstract class AbstractLogHandler
        extends AbstractLogger implements java.io.Serializable {

    // SQL Wrapper.
    protected final static SqlWrapper sqlWrapper = SqlWrapperFactory
            .getSqlWrapper();

    // ----------------------------------------------------- Public abstract methods

    /**
     * Create new log record.
     *
     * @param record the record to insert
     */
    public abstract void insert(AbstractLogRecord record);

    // ----------------------------------------------------- Public static methods

    /**
     * Can user write log or not
     *
     * @param level user log level
     * @return true if can
     */
    public static boolean canLog(int level) {
        return (level <= getSystemLogLevel().intValue());
    }

    /**
     * Get system log level
     *
     * @return Level object
     */
    public final static Level getSystemLogLevel() {
        String prop = SysPropertyManager.getProperty("LOG_LEVEL_DEBUG");
        if(prop != null && prop.equals("1")) {
            return Level.DEBUG;
        }

        prop = SysPropertyManager.getProperty("LOG_LEVEL_INFO");
        if(prop != null && prop.equals("1")) {
            return Level.INFO;
        }

        prop = SysPropertyManager.getProperty("LOG_LEVEL_WARNING");
        if(prop != null && prop.equals("1")) {
            return Level.WARNING;
        }

        prop = SysPropertyManager.getProperty("LOG_LEVEL_ERROR");
        if(prop != null && prop.equals("1")) {
            return Level.ERROR;
        }

        return Level.DEBUG;
    }

}
