/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.services.utils.log.impl;

import com.queplix.core.modules.mail.MailAddress;
import com.queplix.core.modules.mail.MailMessage;
import com.queplix.core.modules.mail.ejb.MailManagerLocal;
import com.queplix.core.modules.mail.ejb.MailManagerLocalHome;
import com.queplix.core.modules.services.utils.log.AbstractLogHandler;
import com.queplix.core.modules.services.utils.log.AbstractLogRecord;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.cache.CacheObjectManager;

import javax.mail.MessagingException;

/**
 * Mail LOG handler
 *
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:02 $
 */

public class MailLogHandler
        extends AbstractLogHandler {

    // ----------------------------------------------------- Public methods

    /*
     * No javadoc
     * @see AbstractLogHandler#insert
     */

    public void insert(AbstractLogRecord r) {

        MailManagerLocal local = (MailManagerLocal) new CacheObjectManager().
                getLocalObject(JNDINames.MailManager,
                        MailManagerLocalHome.class);

        MailLogRecord record = (MailLogRecord) r;
        MailLogConfigurator configurator = new MailLogConfigurator(record);

        if(getLogger().isDebugEnabled()) {
            DEBUG("Mail configurator initializing completed!");
            DEBUG("	Is disabled: " + configurator.isDisabled());
        }

        if(!configurator.isDisabled()) {

            MailLogConfigurator.ConfigVO vos[] = configurator.getVOArray();
            for(int i = 0; i < vos.length; i++) {
                MailMessageHandler hnd = vos[i].getMsgHnd();
                String mailSubject = hnd.getSubject();
                String mailBody = hnd.getBody();
                MailAddress[] maArray = vos[i].getMailAddresses();

                DEBUG("[" + i + "] Try to send error mail with subject '"
                        + mailSubject + "'");

                sendErrorMessage(local,
                        mailSubject,
                        mailBody,
                        maArray);
            }

        } else {
            DEBUG("Skip error mail sending");
        }
    }

    // ----------------------------------------------------- Private methods

    //
    // Sends the error mail.
    //

    private void sendErrorMessage(MailManagerLocal local,
                                  String mailSubject,
                                  String mailBody,
                                  MailAddress[] maArray) {

        // Create MailMessage object.
        MailMessage mm = new MailMessage(maArray, mailSubject, mailBody);

        // Send.
        try {
            local.sendMessage(null, mm, null);
        } catch (MessagingException mex) {
            // Ignore it...
            ERROR(mex);
        }
    }

}
