/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.services.utils.log.impl;

/**
 * Abstract Mail LOG message handler
 *
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:02 $
 */

public abstract class MailMessageHandler {

    // ----------------------------------------------------- Variables

    private MailLogRecord record;
    private String subject;
    private String body;

    // ----------------------------------------------------- Abstract methods

    protected abstract void init();

    // ----------------------------------------------------- Methods

    final void setLogRecord(MailLogRecord record) {
        this.record = record;
    }

    protected final void setSubject(String subject) {
        this.subject = subject;
    }

    protected final void setBody(String body) {
        this.body = body;
    }

    protected final MailLogRecord getLogRecord() {
        return record;
    }

    public final String getSubject() {
        return subject;
    }

    public final String getBody() {
        return body;
    }
}
