/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.services.utils.log.impl;

import com.queplix.core.modules.jeo.gen.ReportSchedulerObject;
import com.queplix.core.modules.services.utils.log.AbstractLogRecord;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Types;

/**
 * Report Scheduler LOG handler
 *
 * @author [LIV] Ilya Ladnev
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:03 $
 */

public class ReportLogHandler
        extends BaseLogHandler {

    // ----------------------------------------------------- Constants

    /** SQL to add a record to the log table. */
    /*    public static final String ADD_EMAIL_SERVICE_LOG_SQL =
            "INSERT INTO QX_EMAIL_SERVICE_LOG (" +
            " EMAIL_SERVICE_LOG_ID," +
            " MESSAGE_ID," +
            " E_TO," +
            " E_FROM," +
            " E_SUBJECT," +
            " POP3ACCOUNT_ID," +
            " CALL_ID," +
            " OWNER_ID," +
            " WORKGROUP_ID," +
            " FILTER_ID," +
            " FORWARD_ID " +
            ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    */
    /**
     * SQL to add a record to the log table.
     */
    public static final String ADD_EMAIL_SERVICE_LOG_SQL =
            "INSERT INTO QX_EMAIL_SERVICE_LOG (" +
                    " EMAIL_SERVICE_LOG_ID," +
                    " MESSAGE_ID," +
                    " OWNER_ID," +
                    " CALL_ID " +
                    ") VALUES (?, ?, ?, ?)";

    // ----------------------------------------------------- Public methods

    /*
     * No javadoc
     * @see AbstractLogHandler#doInsert
     */

    public long doInsert(Connection con, AbstractLogRecord record)
            throws SQLException {

        // Initialization
        Long reportSchedId = null;
        Long reportId = null;
        Long creatorId = null;

        ReportLogRecord lr = (ReportLogRecord) record;
        ReportSchedulerObject reportScheduler = lr.getReportSchedulerObject();
        if(reportScheduler != null) {
            reportSchedId = reportScheduler.getReport_sched_id();
            reportId = reportScheduler.getReport_id();
            creatorId = reportScheduler.getCreated_by();
        }

        // Insert master log record
        long pkey = super.doInsert(con, lr);

        // Insert new record in the QX_EMAIL_SERVICE_LOG table
        PreparedStatement stat = null;
        try {
            stat = sqlWrapper.doPreparedStatement(con,
                    ADD_EMAIL_SERVICE_LOG_SQL);
            stat.setLong(1, pkey);

            if(reportSchedId != null) {
                stat.setLong(2, reportSchedId.longValue());
            } else {
                stat.setNull(2, Types.NUMERIC);
            }

            if(creatorId != null) {
                stat.setLong(3, creatorId.longValue());
            } else {
                stat.setNull(3, Types.NUMERIC);
            }

            if(reportId != null) {
                stat.setLong(4, reportId.longValue());
            } else {
                stat.setNull(4, Types.NUMERIC);
            }

            sqlWrapper.executeUpdate(stat);

        } finally {
            sqlWrapper.closeConnection(stat);
        }

        return pkey;
    }
}
