/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.tools.config;

import com.queplix.core.modules.config.actions.ContextMenuInstallationAction;
import com.queplix.core.tools.AbstractTool;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>Tool which starts ContextMenuInstallationAction execution</p>
 *
 * @author [MVT] Michael Trofimov
 * @version $Revision$ $Date$
 */
public class ContextMenuInstallationTool extends AbstractTool {

    //
    // Call action
    //
    public void callAction(Map params) throws Exception {
        callAction(new ContextMenuInstallationAction(), params);
    }

    //
    // Main method
    //
    public static void main(String[] args) {

        String contextMenuDir = null;

        // parse params
        for(int i = 0; i < args.length; i++) {
            String arg = args[i];

            if(arg.equals("-contextmenufile")) {
                contextMenuDir = args[++i];
            }
        }

        // fill params
        Map params = new HashMap();
        params.put("contextmenufile", contextMenuDir);

        // start action
        try {
            new ContextMenuInstallationTool().callAction(params);

        } catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(
                    "USAGE: java ContextMenuInstallationTool -contextmenufile CONTEXT_MENU_FILE");
        }
    }

}
