/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.cache;

import java.util.Map;

/**
 * <p>JBoss cache event listener</p>
 *
 * @author [ALB] Baranov Andrey
 * @version 1.0
 * @see JBossCacheWrapper
 */

public interface JBossCacheEventListener {

    /**
     * Added/Updated new object.
     *
     * @param key   Object key
     * @param value Object value
     */
    void cacheObjectUpdated(Object key, Object value);

    /**
     * Added/Updated entire Map.
     *
     * @param data Map
     */
    void cacheUpdated(Map data);

    /**
     * Object removed.
     *
     * @param key Object
     */
    void cacheObjectRemoved(Object key);
}
