/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.sql.generic;

import com.queplix.core.utils.sql.parser.LongParser;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;

/**
 * Generic long number parser.
 *
 * @author [ALB] Baranov L. Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:21 $
 */

public class LongParserImpl
        implements LongParser {

    /* (non-Javadoc)
     * @see SqlTypeParser#getObject(ResultSet, int)
     */
    public final Object getObject(ResultSet rs, int i)
            throws SQLException {

        return getValue(rs, i);
    }

    /* (non-Javadoc)
     * @see SqlTypeParser#getObject(CallableStatement, int)
     */
    public final Object getObject(CallableStatement cs, int i)
            throws SQLException {

        return getValue(cs, i);
    }

    /* (non-Javadoc)
     * @see SqlTypeParser#setObject(PreparedStatement, int, Object)
     */
    public final void setObject(PreparedStatement stat, int pos, Object data)
            throws SQLException {

        if(data != null && !(data instanceof Long)) {
            throw new IllegalStateException("Only long supports");
        }

        setValue(stat, pos, (Long) data);
    }

    /* (non-Javadoc)
     * @see LongParser#getValue(ResultSet, int)
     */
    public Long getValue(ResultSet rs, int i)
            throws SQLException {

        Long value = null;
        long num = rs.getLong(i);
        if(!rs.wasNull()) {
            value = new Long(num);
        }
        return value;
    }

    /* (non-Javadoc)
     * @see LongParser#getValue(CallableStatement, int)
     */
    public Long getValue(CallableStatement cs, int i)
            throws SQLException {

        Long value = null;
        long num = cs.getLong(i);
        if(!cs.wasNull()) {
            value = new Long(num);
        }
        return value;
    }

    /* (non-Javadoc)
     * @see LongParser#setValue(PreparedStatement, int, Long)
     */
    public void setValue(PreparedStatement stat, int pos, Long data)
            throws SQLException {

        if(data == null) {
            stat.setNull(pos, Types.BIGINT);
        } else {
            stat.setLong(pos, data.longValue());
        }
    }
}
