/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.sql.generic;

import com.queplix.core.utils.sql.parser.TimeParser;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Types;

/**
 * Generic time parser.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:22 $
 */

public abstract class TimeParserImpl
        implements TimeParser {

    /* (non-Javadoc)
     * @see SqlTypeParser#getObject(ResultSet, int)
     */
    public final Object getObject(ResultSet rs, int i)
            throws SQLException {

        return getValue(rs, i);
    }

    /* (non-Javadoc)
     * @see SqlTypeParser#getObject(CallableStatement, int)
     */
    public final Object getObject(CallableStatement cs, int i)
            throws SQLException {

        return getValue(cs, i);
    }

    /* (non-Javadoc)
     * @see SqlTypeParser#setObject(PreparedStatement, int, Object)
     */
    public final void setObject(PreparedStatement stat, int pos, Object data)
            throws SQLException {

        if(data != null && !(data instanceof Time)) {
            throw new IllegalStateException("Only time supports");
        }

        setValue(stat, pos, (Time) data);
    }

    /* (non-Javadoc)
     * @see TimeParser#getValue(ResultSet, int)
     */
    public Time getValue(ResultSet rs, int i)
            throws SQLException {

        Time time = rs.getTime(i);
        if(rs.wasNull()) {
            return null;
        } else {
            return time;
        }
    }

    /* (non-Javadoc)
     * @see TimeParser#getValue(CallableStatement, int)
     */
    public Time getValue(CallableStatement cs, int i)
            throws SQLException {

        Time time = cs.getTime(i);
        if(cs.wasNull()) {
            return null;
        } else {
            return time;
        }
    }

    /* (non-Javadoc)
     * @see TimeParser#setValue(PreparedStatement, int, Time)
     */
    public void setValue(PreparedStatement stat, int pos, Time time)
            throws SQLException {

        if(time == null) {
            stat.setNull(pos, Types.TIME);
        } else {
            stat.setTime(pos, time);
        }
    }
}
