/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.sql.vendor.mysql;

import com.queplix.core.utils.DateHelper;
import com.queplix.core.utils.sql.generic.DateParserImpl;

import java.util.Date;

/**
 * Mysql date parser implementation.
 */
public class DateParserMysqlImpl extends DateParserImpl {

    /**
     * Build function that convert string into sql Date object.
     *
     * @param date Date object
     * @return sql function with parameter
     */
    public String sqlDateFunction(Date date) {
        String dateStr = DateHelper.formatDate(date, "yyyy-MM-dd");
        StringBuffer sb = new StringBuffer();
        sb.append("STR_TO_DATE('");
        sb.append(dateStr);
        sb.append("', '%Y-%m-%d')");
        return sb.toString();
    }
}
