/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.xml;

import com.queplix.core.utils.log.AbstractLogger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

/**
 * <p>Default error handler for SAX parsers</p>
 *
 * @author [ALB] Baranov L. Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:25 $
 */

public final class DefaultSAXErrorHandler
        extends AbstractLogger
        implements ErrorHandler {

    private boolean throwError = true;

    // CONSTRUCTORS
    public DefaultSAXErrorHandler() {
    }

    public DefaultSAXErrorHandler(boolean throwError) {
        this.throwError = throwError;
    }

    // ERROR HANDLER IMPLEMENTATION
    public void error(SAXParseException ex)
            throws SAXParseException {

        ERROR("PARSER exception:" + ex.getMessage() + " column="
                + ex.getColumnNumber() +
                " row=" + ex.getLineNumber() + " publicId=" + ex.getPublicId() +
                " systemId=" + ex.getSystemId());
        ERROR(ex);

        if(throwError) {
            throw ex;
        }
    }

    public void fatalError(SAXParseException ex)
            throws SAXParseException {

        ERROR("PARSER fatal error:" + ex.getMessage() + " column="
                + ex.getColumnNumber() +
                " row=" + ex.getLineNumber() + " publicId=" + ex.getPublicId() +
                " systemId=" + ex.getSystemId());
        ERROR(ex);

        if(throwError) {
            throw ex;
        }
    }

    public void warning(SAXParseException ex)
            throws SAXParseException {

        ERROR("PARSER warning:" + ex.getMessage() + " column="
                + ex.getColumnNumber() +
                " row=" + ex.getLineNumber() + " publicId=" + ex.getPublicId() +
                " systemId=" + ex.getSystemId());

        if(throwError) {
            throw ex;
        }
    }
}
