/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Image;

/**
 * Image widget that can be connected with image map.
 *
 * @author Michael Trofimov
 */
public class MappedImage extends Image {

    private ImageMap map;

    public MappedImage() {
        super();
        addStyleName("mappedImage");
    }

    public MappedImage(String url) {
        this();
        setUrl(url);
    }

    public MappedImage(String url, ImageMap map) {
        this(url);
        setMap(map);
    }

    public ImageMap getMap() {
        return map;
    }

    public void setMap(ImageMap map) {
        this.map = map;
        DOM.setAttribute(getElement(), "useMap", "#" + map.getName());
    }

}
