/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.ScrollListener;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.queplix.core.client.common.ui.resizable.Resizable;
import com.queplix.core.client.common.ui.resizable.ResizableScrollPanel;
import com.queplix.core.client.common.ui.resizable.ResizableTabPanel;

/**
 * QTabPanel.
 *
 * @author Sultan Tezadov
 * @since 20 Oct 2006
 */
public class QTabPanel extends ResizableTabPanel implements ScrollListener {
    private static final String TAB_STYLE_NAME_PREFIX = "tab_";
    private static final String COMMON_STYLE = TAB_STYLE_NAME_PREFIX + "common";
    private static final String BAR_STYLE = TAB_STYLE_NAME_PREFIX + "tabbar";
    private static final String PANEL_STYLE = TAB_STYLE_NAME_PREFIX
            + "deckpanel";

    public static final int TAB_LAYOUT_DEFAULT = 0;
    public static final int TAB_LAYOUT_VERTICAL = 1;

    private String DEFAULT_WIDTH = "100%";
    private String DEFAULT_HEIGHT = "100%";
    private int currentLayout = TAB_LAYOUT_DEFAULT;

    public QTabPanel(int layout_type) {
        switch(layout_type) {
            case TAB_LAYOUT_VERTICAL:
                currentLayout = TAB_LAYOUT_VERTICAL;
                break;
            default:
                currentLayout = TAB_LAYOUT_DEFAULT;
        }
        addStyleName(COMMON_STYLE);
        getTabBar().setStyleName("grid-TabBar");

        DeckPanel deckPanel = getDeckPanel();
        deckPanel.addStyleName(PANEL_STYLE);
        deckPanel.setHeight(DEFAULT_HEIGHT);
        deckPanel.setWidth(DEFAULT_WIDTH);
    }

    public void addCard(String tabText) {
        if(currentLayout != TAB_LAYOUT_VERTICAL) {
            throw new UnsupportedOperationException(
                    "The method is valid in TAB_LAYOUT_VERTICAL mode only.");
        }
        VerticalPanel verticalPanel = new VerticalPanel();
        add(verticalPanel, tabText);
    }

    public void addToLastCard(Widget w) {
        if(currentLayout != TAB_LAYOUT_VERTICAL) {
            throw new UnsupportedOperationException(
                    "The method is valid in TAB_LAYOUT_VERTICAL mode only.");
        }

        int ind = getDeckPanel().getWidgetCount() - 1;
        if(ind == -1) {
            throw new UnsupportedOperationException(
                    "At least one tab must exist to add a widget.");
        }
        getCardPanel(ind).add(w);
    }

    private VerticalPanel getCardPanel(int index) {
        ResizableScrollPanel rsp = (ResizableScrollPanel) getWidget(index);
        return (VerticalPanel) rsp.getWidget();
    }

    protected ResizableScrollPanel getResizableScrollPanel(int index) {
        return (ResizableScrollPanel) getWidget(index);
    }

    public void insert(Widget widget, String tabText, boolean asHTML,
                       int beforeIndex) {
        if(!(widget instanceof Resizable)) {
            ResizableScrollPanel rsp = new ResizableScrollPanel();
            rsp.addScrollListener(this);
            rsp.add(widget);
            widget = rsp;
        }
        super.insert(widget, tabText, asHTML, beforeIndex);
    }

    public void onScroll(Widget widget, int scrollLeft, int scrollTop) {
    }

}

