/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.common.ui.grid;

import java.util.List;

/**
 * Handles all the selection operations
 *
 * @author Sergey Kozmin
 * @since 30.03.2007
 */
public interface SelectionController {
    public static final int SINGLE_SELECTED_ROW_TYPE = 0;
    public static final int MULTIPLE_SELECTED_ROWS_TYPE = 1;
    //    public static final int CURSOR_SELECTED_ROW_TYPE = 2;
    public static final int NOT_SELECTED_ROW_TYPE = 3;
    public static final int MOUSE_OVER_ROW_TYPE = 4;
    public static final int MOUSE_OUT_ROW_TYPE = 5;

    /**
     * Sets the row type, without any logic.
     *
     * @param row           row index
     * @param selectionType type
     */
    public void setRowType(int row, int selectionType);

    public void setRowsType(int startIndex, int endIndex, int selectionType);

    /**
     * List<Integer>
     *
     * @param rows          list of rows indexes
     * @param selectionType selection type
     */
    public void setRowsType(List rows, int selectionType);

    public void clearSelection();

    /**
     * @return all the selected rows list. List<Integer>. All types
     */
    public List getSelectedRows();

    /**
     * @param selectionType selection type
     * @return only records with the given type. List<Integer>
     */
    public List getSelectedRows(int selectionType);
}
