/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls;

import com.queplix.core.client.app.vo.FieldDataRequest;

/**
 * Listener interface, that determine the way server be notified about data requirements.
 *
 * @author Sergey Kozmin
 * @since 08.11.2006, 18:33:39
 */
public interface FormControlListener {
    /**
     * To be called with appropriate request parameter.
     *
     * @param request request of the appropriate type
     */
    public void needMoreData(FieldDataRequest request);

    /**
     * This method should be called to notify form that control data was
     * changed by user.
     *
     * @param controlId control id
     */
    public void controlDataChanged(String controlId);
}
