/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.controls.datefield;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * Date element in table.
 *
 * @author Sergey Kozmin
 * @since 19 Sep 2006
 */
class DateElement extends Label {
    private int date;
    private DataElementListener dataElementListener;

    public void addDataElementLisner(DataElementListener listener) {
        dataElementListener = listener;
    }

    public interface DataElementListener {
        public void onClick(Widget sender);

        public void onDoubleClick(Widget sender);
    }

    public DateElement(int date) {
        super(String.valueOf(date));
        this.date = date;
        sinkEvents(Event.ONCLICK);
        sinkEvents(Event.ONDBLCLICK);
    }

    public int getDate() {
        return date;
    }

    private void fireDateElementClickEvent() {
        if(dataElementListener != null) {
            dataElementListener.onClick(this);
        }
    }

    private void fireDateElementDoubleClickEvent() {
        if(dataElementListener != null) {
            dataElementListener.onDoubleClick(this);
        }
    }

    public void onBrowserEvent(Event e) {
        switch(DOM.eventGetType(e)) {
            case Event.ONCLICK:
                fireDateElementClickEvent();
                break;
            case Event.ONDBLCLICK:
                fireDateElementDoubleClickEvent();
                break;
        }
    }

}
