/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.form;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;

/**
 * Represents form view
 *
 * @author Sergey Kozmin
 * @since 21.09.2006, 17:50:29
 */
public abstract class QFormView extends Composite {
    protected static final boolean WITHOUT_NOTIFICATION = false;

    protected Label captionLabel = new Label();

    public void setCaption(String caption) {
        captionLabel.setText(caption);
    }

    public String getCaption() {
        return captionLabel.getText();
    }
    
    public abstract boolean isVisible();

    public abstract void setSelected(boolean select);

    public abstract void setAdhocControlsEnabled(boolean isEnabled);

    public abstract void setAdhocControlState(String elementId, int state);

    public abstract int getAdhocControlState(String elementId);

    public abstract boolean isAdhocControlInReport(String elementId);

    public abstract void setCustomButtonsEnabled(String[] buttonsId,
                                                 boolean enabled);
}
