/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.form;

import com.queplix.core.client.frames.mainframe.FormState;

/**
 * Wait for search is finished, if search is successfull and has single entity in response, turn to state selected,
 * otherwise hold on search state.
 *
 * @author Sergey Kozmin
 * @since 02.10.2006, 18:39:27
 */
class SearchUnit extends BaseChainUnit {
    private ChainUnitContext unitContext;

    public SearchUnit(ChainUnitContext unitContext) {
        this.unitContext = unitContext;
    }

    public boolean isAccepted(int event) {
        return event == SEARCH_SUCCESSFUL_SINGLE ||
//                event == SEARCH_SUCCESSFUL_MULTIPLE ||
                event == SEARCH_FAILED;
    }

    public void handleEvent(int event) throws IncorrectFormActionPerformed {
        switch(event) {
            case SEARCH_SUCCESSFUL_SINGLE: {
                unitContext.changeState(FormState.SELECTED_STATE);
                break;
            }
        }
    }

    public String getName() {
        return "Search unit";
    }
}
